definition module deltaFont

//1.3
from StdString import String 
//3.1

//	:: Font
	
//	:: FontName  :== String
//	:: FontStyle :== String
//	:: FontSize  :== Int
//	:: FontInfo  :== (!Int,!Int,!Int,!Int)
	
//	MinFontSize :== 4
//	MaxFontSize :== 128
	
/*	SelectFont creates the font as specified by the name, the stylistic
	variations and size. In case there are no FontStyles ([]), the font
	is selected without stylistic variations (i.e. in plain style).
	The size is always adjusted between MinFontSize and MaxFontSize.
	The boolean result is True in case this font is available and needn't
	be scaled. In case the font is not available, the default font is
	chosen in the indicated style and size. */

//	SelectFont :: !FontName ![FontStyle] !FontSize -> (!Bool, !Font)


/*	DefaultFont returns name, style and size of the default font. */
//	DefaultFont :: (!FontName, ![FontStyle], !FontSize) 


/*	FontNames	returns the FontNames of all available fonts.
	FontStyles	returns the FontStyles of all available styles.
	FontSizes	returns all FontSizes of a font that are available without scaling.
	In case the font is unavailable, the styles or sizes of the default font
	are returned. */
//	FontNames        ::              [ FontName ]
//	FontSizes        :: !FontName -> [ FontSize ]
//	FontStyles       :: !FontName -> [ FontStyle ] 

/*	FontMetrics yields the FontInfo in terms of pixels of a given Font. The FontInfo
	is a four-tuple (ascent, descent, max width, leading) which defines the metrics
	of a font:
		- ascent	is the height of the top most character measured from the base
		- descent	is the height of the bottom most character measured from the base
		- max width	is the width of the widest character including spacing
		- leading	is the vertical distance between two lines of the same font.
	The full height of a line is the sum of the ascent, descent and leading. */

//	FontMetrics      ::           !Font -> FontInfo

/*	FontCharWidth(s) (FontStringWidth(s)) return the width(s) in terms of pixels
	of given character(s) (string(s)) for a particular Font. */
//	FontCharWidth    :: !Char     !Font -> Int
//	FontCharWidths   :: ![Char]   !Font -> [Int]
//	FontStringWidth  :: !String   !Font -> Int
//	FontStringWidths :: ![String] !Font -> [Int]
	

//1.3
from picture import Font, FontName, FontStyle, FontSize, FontInfo,
					MinFontSize, MaxFontSize, SelectFont, DefaultFont, FontNames,
					FontSizes, FontStyles, FontMetrics, FontCharWidth,
					FontCharWidths, FontStringWidth, FontStringWidths
//3.1
/*2.0
from picture import FontCharWidth, FontCharWidths, FontStringWidth, FontStringWidths, 
 	SelectFont, DefaultFont, FontNames, FontSizes, FontStyles, FontMetrics, 
 	:: FontStyle, :: FontSize, :: FontInfo, MinFontSize, MaxFontSize, 
 	:: FontName, :: Font;
0.2*/
